<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/displaytag-12.tld" prefix="display" %>
<%@ taglib uri="http://beehive.apache.org/netui/tags-html-1.0" prefix="netui" %>

<c:set var="pageHelp" value="${pageFlow.summaryHelpURI}" />
<c:set var="printerFriendlyPageAction" value="viewPrinterFriendlyIndex" />

<%@ include file="appointmentPageHeader.jspf" %>
<%@ include file="appointmentSummaryDescription.jspf" %>

<p>
	<display:table id="${pageFlow.tableUID}" 
	        uid="${pageFlow.tableUID}" 
		    name="${pageFlow.appointments}"
	        pagesize="10" 
	        sort="list"  
	        defaultsort="${pageFlow.defaultSortProperty}" 
	        defaultorder="${pageFlow.defaultSortOrder.name}"
	        decorator="${pageFlow.decoratorClassName}"
	        requestURI="handlePagingAndSorting.do">
	    <display:setProperty name="custom.sort.class" 
            value="${pageFlow.sortClassName}" />
		<display:column property="appointmentDate" sortable="true" sortProperty="appointmentDateObj" 
		    title="Appointment Date/Time"/>
		<display:column property="appointmentStatus" sortable="true"  
		    title="Status"/>
		    <netui:content value="${pageFlow.currentAppointment.appointmentStatus}"/>
		<display:column property="clinicName" sortable="true" title="Clinic" 
		    href="viewDetails.do" paramId="id" paramProperty="id"/>
		<display:column property="location" sortable="true" 
		    title="Location"/>
	</display:table>
</p>

<br />
<%@ include file="../../common/pageFooter.jspf" %>